<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class HomeController extends Controller
{
    private function decodeApiJson(string $body): ?array
    {
        $clean = trim(strip_tags($body));
        $clean = html_entity_decode($clean, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        $clean = preg_replace('/^\xEF\xBB\xBF/', '', $clean);
        $clean = preg_replace('/,\s*([}\]])/m', '$1', $clean);

        $decoded = json_decode($clean, true);
        if (json_last_error() !== JSON_ERROR_NONE && preg_match('/\{.*\}/s', $clean, $m)) {
            $decoded = json_decode($m[0], true);
        }
        return is_array($decoded) ? $decoded : null;
    }

    public function index(Request $request)
    {
        $apiUrl = 'http://110.38.68.210:8080/isr/tmh/api/doctor';

        // same pattern you used: fetch with specialty=MBBS for full list
        $resp = Http::timeout(10)->retry(2, 300)
            ->withHeaders(['User-Agent' => 'TMH-Laravel-Client/1.0', 'Accept' => '*/*'])
            ->get($apiUrl, ['branch' => 'KARACHI', 'department' => 'ALL', 'specialty' => 'MBBS']);

        $branches = collect();
        $departments = collect();

        if ($resp->ok()) {
            $json = $this->decodeApiJson($resp->body());
            $data = is_array($json['data'] ?? null) ? $json['data'] : [];

            $branches = collect($data)->pluck('branch')
                ->filter(fn($v)=>filled($v))->map(fn($v)=>strtoupper(trim($v)))
                ->unique()->sort()->values();

            $departments = collect($data)->pluck('department')
                ->filter(fn($v)=>filled($v))->map(fn($v)=>strtoupper(trim($v)))
                ->unique()->sort()->values();
        }

        return view('pages.home', [ // adjust to your home view name
            'branches'    => $branches,     // e.g., KARACHI, HYDERABAD, etc (if present)
            'departments' => $departments,  // used as “specialty” param on results page
        ]);
    }
}
