<!doctype html>
<html lang="en-US">
<head>
  <meta charset="UTF-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <title>@yield('title', 'The Modern Hospital')</title>
  <meta name="description" content="@yield('meta_description', '')" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  {{-- Favicon --}}
  <link rel="icon" type="image/png" sizes="56x56" href="{{ asset('assets/images/resource/logo-small-1.png') }}" />

  {{-- CSS (order matters: framework/vendor -> theme -> custom) --}}
  <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/all.min.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/flaticon.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/theme-default.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/meanmenu.min.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/bootstrap-icons.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/odometer-theme-default.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/responsive.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/swiper.min.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/css/aos.css') }}">
  {{-- Venobox (moved under public/vendor/venobox) --}}
  <link rel="stylesheet" href="{{ asset('vendor/venobox/venobox.css') }}">
  {{-- Slick from CDN (as in your original) --}}
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick-theme.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
  {{-- Main theme at the end to allow overrides --}}
  <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">

  {{-- Fonts --}}
  <link href="https://fonts.cdnfonts.com/css/clash-display" rel="stylesheet" />

  {{-- Modernizr (you had this in <head>) --}}
  <script src="{{ asset('assets/js/vendor/modernizr-3.5.0.min.js') }}"></script>

  @stack('styles')
</head>
<body>
  {{-- Loader --}}
  <div class="loader-wrapper">
    <img src="{{ asset('assets/images/resource/logo-small-1.png') }}" class="loader" alt="">
    <div class="loder-section left-section"></div>
    <div class="loder-section right-section"></div>
  </div>

  {{-- Header / Navigation --}}
  @include('partials.header')

  {{-- Page content --}}
  @yield('content')

  {{-- Footer --}}
  @include('partials.footer')
    </div>

</div>
  {{-- Scroll-up --}}
  <div id="progress" class="progress hide"><div id="progress-value"></div></div>
</div>
  {{-- JS (order matters: jQuery -> vendor plugins -> theme/custom) --}}
  <script src="{{ asset('assets/js/vendor/jquery-3.6.2.min.js') }}"></script>
  <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
  <script src="{{ asset('assets/js/gsap.min.js') }}"></script>
  <script src="{{ asset('assets/js/ScrollSmoother.min.js') }}"></script>
  <script src="{{ asset('assets/js/ScrollToPlugin.min.js') }}"></script>
  <script src="{{ asset('assets/js/ScrollTrigger.min.js') }}"></script>
  <script src="{{ asset('assets/js/aos.js') }}"></script>
  <script src="{{ asset('assets/js/odometer.min.js') }}"></script>
  <script src="{{ asset('assets/js/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.meanmenu.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.scrollUp.js') }}"></script>
  <script src="{{ asset('assets/js/appear.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.barfiller.js') }}"></script>
  <script src="{{ asset('assets/js/videoplayback.js') }}"></script>
  <script src="{{ asset('assets/js/swiper.min.js') }}"></script>

  {{-- Venobox (pick one .min file) --}}
  <script src="{{ asset('vendor/venobox/venobox.min.js') }}"></script>
  {{-- Slick --}}
  <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  {{-- Your custom scripts --}}
  <script src="{{ asset('assets/js/whatsNewSwiper.js') }}"></script>
  <script src="{{ asset('assets/js/theme.js') }}"></script>
  <script src="{{ asset('assets/js/my.js') }}"></script>

  @stack('scripts')
</body>
</html>
