@if ($paginator->hasPages())
  <nav role="navigation" aria-label="Pagination">
    <ul class="pagination">
      {{-- Previous --}}
      @if ($paginator->onFirstPage())
        <li class="page-item disabled" aria-disabled="true" aria-label="Previous">
          <span class="page-link" aria-hidden="true">&laquo;</span>
        </li>
      @else
        <li class="page-item">
          <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev" aria-label="Previous">&laquo;</a>
        </li>
      @endif

      {{-- Numbered links (and possible separators) --}}
      @foreach ($elements as $element)
        @if (is_string($element))
          <li class="page-item disabled" aria-disabled="true"><span class="page-link">{{ $element }}</span></li>
        @endif

        @if (is_array($element))
          @foreach ($element as $page => $url)
            @if ($page == $paginator->currentPage())
              <li class="page-item active" aria-current="page">
                <span class="page-link">{{ $page }}</span>
              </li>
            @else
              <li class="page-item">
                <a class="page-link" href="{{ $url }}">{{ $page }}</a>
              </li>
            @endif
          @endforeach
        @endif
      @endforeach

      {{-- Next --}}
      @if ($paginator->hasMorePages())
        <li class="page-item">
          <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next" aria-label="Next">&raquo;</a>
        </li>
      @else
        <li class="page-item disabled" aria-disabled="true" aria-label="Next">
          <span class="page-link" aria-hidden="true">&raquo;</span>
        </li>
      @endif
    </ul>
  </nav>
@endif
