<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/find-a-doctor.styles.css')); ?>" type="text/css" />
<?php $__env->stopPush(); ?>



<?php $__env->startSection('title', 'Find a Doctor | The Modern Hospital'); ?>

<?php $__env->startSection('content'); ?>
<div id="smooth-wrapper">
  <div id="smooth-content">

    <div class="main-page-header">
      <h1>Find a Doctor</h1>
      <p>The Modern Hospital / Doctors</p>
    </div>

    <div class="hospital-guide-wrapper">
      <div class="container">

        
        <div class="row doctors-section">
          <div class="col-12 p-0">
            <div class="row">
              <div class="col-lg-12">
                <form class="doctor-filter_form" method="GET" action="<?php echo e(route('doctors.index')); ?>">
                  <div class="form-group">
                    <select class="form-control" id="specialty" name="specialty">
                      <option value="ALL" <?php echo e(($specialty ?? 'ALL') === 'ALL' ? 'selected' : ''); ?>>All Specialties</option>
                      <?php $__currentLoopData = $specialties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($opt); ?>" <?php echo e(($specialty ?? '') === $opt ? 'selected' : ''); ?>>
                          <?php echo e($opt); ?>

                        </option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <label for="specialty">Specialty</label>
                  </div>

                  <div class="form-group">
                    <input type="text" class="form-control" id="doctor" name="doctor" value="<?php echo e($name ?? ''); ?>" />
                    <label for="doctor">Doctor/Practitioner’s Name</label>
                  </div>

                  <div class="form-group">
                    <input type="text" class="form-control" id="keyword" name="keyword" value="<?php echo e($keyword ?? ''); ?>" />
                    <label for="keyword">Keyword, organ or disease</label>
                  </div>

                  <div class="form_actions">
                    <button type="submit">
                      Search <i class="fa-solid fa-magnifying-glass"></i>
                    </button>
                    <a href="<?php echo e(route('doctors.index')); ?>">
                      View All <i class="bi bi-arrow-return-right"></i>
                    </a>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

        
        <div class="row doctors-list_wrapper">
          <div class="col-12 doctors-list">
            <?php $__empty_1 = true; $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <div class="doctor-list_item">
                <div class="doctor-card">
                  <h3 class="doctor-name"><?php echo e(ucwords(strtolower($doc['name']))); ?></h3>
                  <p class="doctor-specialty">
                    <?php echo e(strtoupper($doc['department'])); ?>

                    <?php if(!empty($doc['specialty'])): ?> • <?php echo e(strtoupper($doc['specialty'])); ?> <?php endif; ?>
                  </p>

                  <div class="doctor-image">
                    <img src="<?php echo e($doc['image']); ?>" alt="<?php echo e($doc['name']); ?>">
                    <!-- <div class="overlay">
                      <div class="social-icons">
                        <a href="#"><i class="fab fa-whatsapp"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-facebook"></i></a>
                      </div>
                    </div> -->
                  </div>

                  <!-- <?php if(!empty($doc['education'])): ?>
                    <p class="mt-2"><strong>Education:</strong> <?php echo e($doc['education']); ?></p>
                  <?php endif; ?> -->
                  <!-- <?php if(!empty($doc['contact'])): ?>
                    <p><strong>Contact:</strong> <?php echo e($doc['contact']); ?></p>
                  <?php endif; ?> -->

                  <!-- <?php if(!empty($doc['schedule'])): ?>
                    <div class="doctor-schedule">
                      <strong>Schedule:</strong>
                      <ul class="schedule-list">
                        <?php $__currentLoopData = $doc['schedule']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li><?php echo e($slot['day']); ?>: <?php echo e(\Illuminate\Support\Str::of($slot['start'])->limit(5, '')); ?> - <?php echo e(\Illuminate\Support\Str::of($slot['end'])->limit(5, '')); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>
                    </div>
                  <?php endif; ?> -->

                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <p>No doctors found.</p>
            <?php endif; ?>
          <?php if($doctors instanceof \Illuminate\Pagination\LengthAwarePaginator): ?>
            <div class="mt-4 d-flex justify-content-center">
                <?php echo e($doctors->appends(request()->query())->onEachSide(1)->links('vendor.pagination.numbers-only')); ?>

            </div>
            <?php endif; ?>
          </div>
        </div>

      </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\E Drive\Projects\The Modren Hospital\tmh\resources\views/pages/find-a-doctor.blade.php ENDPATH**/ ?>