<?php
  // helper for active classes (matches path prefixes)
  $is = fn($pattern) => request()->is($pattern);
?>

<!-- Main Menu -->
<div id="sticky-header" class="mediic_nav_manu">
  <div class="container-fluid secondary-menu">
    <div class="row align-items-center">
      <div class="col-lg-12">
        <div id="top-nav">
          <ul class="top-nav_icons">
            <li class="top-nav_icon__item">
              <img src="<?php echo e(asset('assets/images/resource/contact-us-icon.svg')); ?>" alt="">
              <a class="<?php echo e($is('contact-us') ? 'active' : ''); ?>" href="<?php echo e(url('/contact-us')); ?>">CONTACT US</a>
            </li>
            <li class="top-nav_icon__item">
              <img src="<?php echo e(asset('assets/images/resource/location-icon.svg')); ?>" alt="">
              <a href="#!">LOCATION</a>
            </li>
            <li class="top-nav_icon__item">
              <img src="<?php echo e(asset('assets/images/resource/ambulance-icon.svg')); ?>" alt="">
              <a class="<?php echo e($is('ambulance-services-1') ? 'active' : ''); ?>" href="<?php echo e(url('/ambulance-services-1')); ?>">AMBULANCE</a>
            </li>
          </ul>

          <div class="header-button">
            <a href="#!">
              <img class="icon" src="<?php echo e(asset('assets/images/resource/nursing-college-icon.svg')); ?>" alt="">
              NURSING COLLEGE
              <div class="mediic-hover-btn hover-btn"></div>
              <div class="mediic-hover-btn hover-btn2"></div>
              <div class="mediic-hover-btn hover-btn3"></div>
              <div class="mediic-hover-btn hover-btn4"></div>
            </a>
            <a href="#!">
              Book an APPOINTMENT
              <img src="<?php echo e(asset('assets/images/resource/arrow.png')); ?>" alt="" />
              <div class="mediic-hover-btn hover-btn"></div>
              <div class="mediic-hover-btn hover-btn2"></div>
              <div class="mediic-hover-btn hover-btn3"></div>
              <div class="mediic-hover-btn hover-btn4"></div>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="divider secondary-menu-divider" style="border: 1px solid #B7B7B7; width: 100vw; margin: 10px auto; transform: translateX(-20px);"></div>

  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-lg-2">
        <div class="logo cursor-scale small">
          <a class="logo_img" href="<?php echo e(url('/')); ?>" title="The Modern Hospital">
            <img src="<?php echo e(asset('assets/images/resource/tmh-logo.png')); ?>" alt="logo" />
          </a>
          <a class="main_sticky" href="<?php echo e(url('/')); ?>" title="The Modern Hospital">
            <img src="<?php echo e(asset('assets/images/resource/tmh-logo.png')); ?>" alt="logo" />
          </a>
        </div>
      </div>

      <div class="col-xl-8 col-lg-10">
        <nav class="mediic_menu">
          <ul class="nav_scroll">
            
            <li class="<?php echo e($is('about-us*') ? 'active' : ''); ?>">
              <a class="mdy-hover cursor-scale small" href="#!">ABOUT</a>
              <ul class="sub-menu">
                <li><a class="<?php echo e($is('about-us') ? 'active' : ''); ?>" href="<?php echo e(url('/about-us')); ?>">About TMH</a></li>
                <li><a class="<?php echo e($is('about-us#message-from-ceo') ? 'active' : ''); ?>" href="<?php echo e(url('/about-us#message-from-ceo')); ?>">Welcome by CEO</a></li>
                <li><a class="<?php echo e($is('about-us#vison-mission') ? 'active' : ''); ?>" href="<?php echo e(url('/about-us#vison-mission')); ?>">Vision, Mission and Values</a></li>
                <li><a class="<?php echo e($is('about-us#accreditations') ? 'active' : ''); ?>" href="<?php echo e(url('/about-us#accreditations')); ?>">Accreditations</a></li>
              </ul>
            </li>

            
            <li class="<?php echo e($is('hospitals*') ? 'active' : ''); ?>">
              <a class="mdy-hover cursor-scale small" href="#!">HOSPITALS</a>
              <ul class="sub-menu">
                <li>
                  <a href="#!">TMH Karachi</a>
                  <ul class="sub-menu">
                    <li><a class="<?php echo e($is('hospitals/karachi') ? 'active' : ''); ?>" href="<?php echo e(url('/hospitals/karachi')); ?>">About TMH Karachi</a></li>
                    <li><a href="#!">Virtual Tour</a></li>
                    <li><a class="<?php echo e($is('hospital-guide') ? 'active' : ''); ?>" href="<?php echo e(url('/hospital-guide')); ?>">Hospital Guide</a></li>
                    <li><a class="<?php echo e($is('hospital-facilities') ? 'active' : ''); ?>" href="<?php echo e(url('/hospital-facilities')); ?>">Hospital Facility</a></li>
                    <li><a class="<?php echo e($is('hospital-admissions') ? 'active' : ''); ?>" href="<?php echo e(url('/hospital-admissions')); ?>">Hospital Admissions</a></li>
                    <li><a class="<?php echo e($is('diagnostic-laboratory-service') ? 'active' : ''); ?>" href="<?php echo e(url('/diagnostic-laboratory-service')); ?>">Diagnostic & Laboratory Services</a></li>
                    <li><a class="<?php echo e($is('pharmacy') ? 'active' : ''); ?>" href="<?php echo e(url('/pharmacy')); ?>">Pharmacy</a></li>
                    <li><a class="<?php echo e($is('clinics-schedule') ? 'active' : ''); ?>" href="<?php echo e(url('/clinics-schedule')); ?>">Clinics and Schedule</a></li>
                  </ul>
                </li>
                <li><a class="<?php echo e($is('hospitals/gharo') ? 'active' : ''); ?>" href="<?php echo e(url('/hospitals/gharo')); ?>">TMH Gharo</a></li>
                <li><a class="<?php echo e($is('hospitals/hyderabad') ? 'active' : ''); ?>" href="<?php echo e(url('/hospitals/hyderabad')); ?>">TMH Hyderabad</a></li>
                <li><a class="<?php echo e($is('hospitals/saeedabad') ? 'active' : ''); ?>" href="<?php echo e(url('/hospitals/saeedabad')); ?>">TMH New Saeedabad</a></li>
                <li><a class="<?php echo e($is('hospitals/mirpurkhas') ? 'active' : ''); ?>" href="<?php echo e(url('/hospitals/mirpurkhas')); ?>">TMH Mirpurkhan</a></li>
                <li><a class="<?php echo e($is('hospitals/mithi') ? 'active' : ''); ?>" href="<?php echo e(url('/hospitals/mithi')); ?>">TMH Mithi</a></li>
                <li><a class="<?php echo e($is('hospitals/islamkot') ? 'active' : ''); ?>" href="<?php echo e(url('/hospitals/islamkot')); ?>">TMH Islamkot</a></li>
              </ul>
            </li>

            
            <li class="<?php echo e($is('medical-centers*') || $is('pharmacies*') ? 'active' : ''); ?>">
              <a class="mdy-hover cursor-scale small" href="#!">MEDICAL CENTERS</a>
              <ul class="sub-menu">
                <li><a class="<?php echo e($is('medical-centers') ? 'active' : ''); ?>" href="<?php echo e(url('/medical-centers')); ?>">Medical Centers</a></li>
                <li><a class="<?php echo e($is('pharmacies') ? 'active' : ''); ?>" href="<?php echo e(url('/pharmacies')); ?>">Pharmacies</a></li>
              </ul>
            </li>

            
            <li class="<?php echo e($is('laboratories*') ? 'active' : ''); ?>">
              <a class="mdy-hover cursor-scale small <?php echo e($is('laboratories') ? 'active' : ''); ?>" href="<?php echo e(url('/laboratories')); ?>">LABORATORIES</a>
              <ul class="sub-menu">
                <li><a class="<?php echo e($is('laboratories-packages') ? 'active' : ''); ?>" href="<?php echo e(url('/laboratories-packages')); ?>">Clinical Laboratories Packages</a></li>
                <li><a class="<?php echo e($is('lab-sample-collection') ? 'active' : ''); ?>" href="<?php echo e(url('/lab-sample-collection')); ?>">Lab Sample Collection Request</a></li>
                <li><a class="<?php echo e($is('find-laboratories') ? 'active' : ''); ?>" href="<?php echo e(url('/find-laboratories')); ?>">Find Your Nearest Laboratory</a></li>
                <li><a class="<?php echo e($is('laboratory-test') ? 'active' : ''); ?>" href="<?php echo e(url('/laboratory-test')); ?>">Our Laboratory Test</a></li>
                <li><a href="#!">Covid – 19 Test</a></li>
              </ul>
            </li>

            
            <li class="<?php echo e($is('health-solutions*') || $is('health-packages*') || $is('treatment-services*') || $is('home-health-services*') ? 'active' : ''); ?>">
              <a class="mdy-hover cursor-scale small" href="<?php echo e(url('/health-solutions')); ?>">HEALTH SOLUTIONS</a>
              <ul class="sub-menu">
                <li><a class="<?php echo e($is('health-solutions') ? 'active' : ''); ?>" href="<?php echo e(url('/health-solutions')); ?>">Clinics</a></li>
                <li><a class="<?php echo e($is('health-packages') ? 'active' : ''); ?>" href="<?php echo e(url('/health-packages')); ?>">Health Packages</a></li>
                <li><a class="<?php echo e($is('treatment-services') ? 'active' : ''); ?>" href="<?php echo e(url('/treatment-services')); ?>">Treatments and Services</a></li>
                <li><a class="<?php echo e($is('home-health-services') ? 'active' : ''); ?>" href="<?php echo e(url('/home-health-services')); ?>">Home Health Services</a></li>
                <li><a class="<?php echo e($is('second-opinion-services') ? 'active' : ''); ?>" href="<?php echo e(url('/second-opinion-services')); ?>">Second Opinion Services</a></li>
                <li><a class="<?php echo e($is('medical-travel-services') ? 'active' : ''); ?>" href="<?php echo e(url('/medical-travel-services')); ?>">Medical Travel Solutions</a></li>
              </ul>
            </li>

            
            <li class="<?php echo e($is('find-a-doctor*') || $is('plan-appointment*') || $is('available-payment-options*') || $is('referral-services*') ? 'active' : ''); ?>">
              <a class="mdy-hover cursor-scale small" href="#!">PATIENT SERVICES</a>
              <ul class="sub-menu">
                <li><a class="<?php echo e($is('find-a-doctor') ? 'active' : ''); ?>" href="<?php echo e(url('/find-a-doctor')); ?>">Find a Doctor</a></li>
                <li><a class="<?php echo e($is('plan-appointment') ? 'active' : ''); ?>" href="<?php echo e(url('/plan-appointment')); ?>">Prepare for Your Visit</a></li>
                <li><a class="<?php echo e($is('available-payment-options') ? 'active' : ''); ?>" href="<?php echo e(url('/available-payment-options')); ?>">Payment Options</a></li>
                <li><a href="#!">Concierge Services</a></li>
                <li><a class="<?php echo e($is('referral-services') ? 'active' : ''); ?>" href="<?php echo e(url('/referral-services')); ?>">Referral Services</a></li>
                <li><a class="<?php echo e($is('ambulance-services-1') ? 'active' : ''); ?>" href="<?php echo e(url('/ambulance-services-1')); ?>">Ambulance Services</a></li>
              </ul>
            </li>

            
            <li class="<?php echo e($is('patient-welfare*') ? 'active' : ''); ?>">
              <a class="mdy-hover cursor-scale small" href="#!">PATIENT WELFARE</a>
              <ul class="sub-menu">
                <li><a href="#!">Welfare Support</a></li>
                <li><a href="#!">Zakat Support</a></li>
                <li><a href="#!">How to Apply</a></li>
                <li><a href="#!">Donate and Support</a></li>
              </ul>
            </li>
          </ul>
        </nav>
      </div>

      <div class="col-lg-2">
        <div class="mediic-right-side cursor-scale small">
          <div class="search-box-btn search-box-outer">
            <i class="fa-solid fa-magnifying-glass"></i>
          </div>
          <div class="sidebar">
            <div class="nav-btn navSidebar-button">
              <span><i class="bi bi-grid-3x3-gap-fill"></i></span>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>


<div class="mobile-menu-area sticky d-sm-block d-md-block d-lg-none">
    <div class="mobile-menu">
      <nav class="mediic_menu">
        <ul class="nav_scroll">
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">ABOUT </a>
            <ul class="sub-menu">
              <li><a href="!#">About TMH</a></li>
              <li><a href="!#">Welcome by CEO</a></li>
              <li><a href="!#">Vision, Mission and Values</a></li>
              <li><a href="!#">Accreditations</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">HOSPITALS </a>
            <ul class="sub-menu">
              <li><a href="/hospitals/karachi.html">THM Karachi</a></li>
              <li><a href="/hospitals/gharo.html">TMH Gharo</a></li>
              <li><a href="/hospitals/hyderabad.html">TMH Hyderabad</a></li>
              <li><a href="/hospitals/saeedabad.html">TMH New Saeedabad</a></li>
              <li><a href="/hospitals/mirpurkhas.html">TMH Mirpurkhan</a></li>
              <li><a href="/hospitals/mithi.html">TMH Mithi</a></li>
              <li><a href="/hospitals/islamkot.html">TMH Islamkot</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">MEDICAL CENTERS </a>
            <ul class="sub-menu">
              <li><a href="/medical-centers.html">Medical Centers</a></li>
              <li><a href="/pharmacies.html">Pharmacies</a></li>
            </ul>
          </li>
          <li>
            <a href="/laboratories.html">LABORATORIES</a>
            <ul class="sub-menu">
              <li><a href="/laboratories-packages.html">Clinical Laboratories Packages</a></li>
              <li><a href="/lab-sample-collection.html">Lab Sample Collection Request</a></li>
              <li><a href="/find-laboratories.html">Find Your Nearest Laboratory</a></li>
              <li><a href="/laboratory-test.html">Our Laboratory Test</a></li>
              <li><a href="!#">Covid – 19 Test</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="/health-solutions.html">HEALTH SOLUTIONS </a>
            <ul class="sub-menu">
              <li><a href="/health-solutions.html">Clinics</a></li>
              <li><a href="/health-packages.html">Health Packages</a></li>
              <li><a href="/treatment-services.html">Treatments and Services</a></li>
              <li><a href="/home-health-services.html">Home Health Services</a></li>
              <li><a href="/second-opinion-services.html">Second Opinion Services</a></li>
              <li><a href="/medical-travel-services.html">Medical Travel Solutions</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">PATIENT SERVICES </a>
            <ul class="sub-menu">
              <li><a href="/find-a-doctor.html">Find a Doctor</a></li>
              <li><a href="/plan-appointment.html">Prepare for Your Visit</a></li>
              <li><a href="/available-payment-options.html">Payment Options</a></li>
              <li><a href="!#">Concierge Services</a></li>
              <li><a href="/referral-services.html">Referral Services</a></li>
              <li><a href="ambulance-services-1.html">Ambulance Services</a></li>
            </ul>
          </li>
          <li>
            <a class="mdy-hover cursor-scale small" href="#!">PATIENT WELFARE </a>
            <ul class="sub-menu">
              <li><a href="!#">Welfare Support</a></li>
              <li><a href="!#">Zakat Support</a></li>
              <li><a href="!#">How to Apply</a></li>
              <li><a href="!#">Donate and Support</a></li>
            </ul>
          </li>

        </ul>
      </nav>
    </div>
  </div>
<?php /**PATH D:\E Drive\Projects\The Modren Hospital\tmh\resources\views/partials/header.blade.php ENDPATH**/ ?>