<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/hospitals/karachi.css')); ?>" type="text/css" />
<?php $__env->stopPush(); ?>



<?php $__env->startSection('title', 'TMH Karachi | The Modern Hospital'); ?>

<?php $__env->startSection('content'); ?>

  
  <div id="smooth-wrapper">
    <div id="smooth-content">

      
        <div class="main-page-header">
            <h1>The Modern Hospital Karachi</h1>
            <p>Karachi / Home</p>
        </div>

        <!-- Text Block -->
        <div class="about-us-text">
            <div class="container">
                <div class="row">
                    <div class="col">
                        <h2>Welcome to The Modern Hospital, Karachi</h2>
                        <p>
                            At The Modern Hospital, we are dedicated to providing the highest quality
                            healthcare to our
                            patients. Located in the heart of Karachi at Gulshan-e-Iqbal, Block-7, opposite
                            to Safari
                            Park,
                            our 100-bed facility is designed with a modern infrastructure that supports both
                            outpatient
                            and
                            inpatient care, ensuring a seamless and patient-centered experience.
                        </p>
                        <p>
                            Our hospital's infrastructure emphasizes a holistic approach to healthcare,
                            creating a
                            welcoming
                            and healing environment. The thoughtfully designed spaces promote comfort,
                            accessibility,
                            and
                            well-being for both patients and their families. Each area, from our
                            state-of-the-art
                            emergency
                            room to our patient wards, is crafted to foster a sense of safety and care.
                        </p>
                        <p>
                            Our highly skilled and dedicated team of medical professionals, driven by values
                            of service
                            and
                            dignity, is committed to delivering exceptional patient care. We offer 24/7
                            Emergency (ER),
                            Laboratory, Radiology, Pharmacy, and Home Healthcare Services, including
                            laboratory test
                            sample
                            collection, medicine delivery, and online consultations, ensuring that patients
                            receive
                            continuous support at home.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="specializations-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col">
                        <h3>The Modern Hospital Karachi<br> has specialized departments such as:</h3>
                    </div>
                </div>
                <!-- cards -->
                <div class="row align-items-center my-5">
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Cardiologist-icon.svg')); ?>"
                                        alt="Cardiovascular Department">
                                    <p class="specialization-tag">Cardiologist</p>
                                </div>
                                <div class="spacer"></div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Cardiovascular Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Gastroenterologist-icon.svg')); ?>"
                                        alt="Gastroenterologist">
                                    <p class="specialization-tag">Gastroenterologist</p>
                                </div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Gastroenterology Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Orthopedic-Surgeon-icon.svg')); ?>"
                                        alt="Orthopedic-Surgeon">
                                    <p class="specialization-tag">Orthopedic<br />Surgeon</p>
                                </div>
                                <div class="spacer"></div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Trauma & Orthopedics Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Pulmonologist-icon.svg')); ?>"
                                        alt="Pulmonologist">
                                    <p class="specialization-tag">Pulmonologist</p>
                                </div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Pulmonology Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Neurologist-icon.svg')); ?>"
                                        alt="Neurology Department">
                                    <p class="specialization-tag">Neurologist</p>
                                </div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Neurology Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Oncologist-icon.svg')); ?>"
                                        alt="Oncology Department">
                                    <p class="specialization-tag">Oncologist</p>
                                </div>
                                <div class="spacer"></div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Oncology Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Endocrinologists-icon.svg')); ?>"
                                        alt="Diabetes & Endocrine Department">
                                    <p class="specialization-tag">Endocrinologists</p>
                                </div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Diabetes & Endocrine Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="specialization-item">
                            <div class="overlay"></div>
                            <div class="specialization-card">
                                <div class="card-head">
                                    <img src="<?php echo e(asset('assets/images/resource/about/Gynecologist-icon.svg')); ?>"
                                        alt="Gynecology Department">
                                    <p class="specialization-tag">Gynecologist</p>
                                </div>
                                <div class="spacer"></div>
                                <div class="card-body">
                                    <a href="#!">
                                        <h4>Gynecology Department</h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- text -->
                <div class="row extra-text px-lg-5 mb-5 mt-4">
                    <div class="col">
                        <p>
                            In addition to these specialized departments, our hospital is home to some of
                            Karachi's leading consultants in internal medicine, general and advanced
                            surgery, and pediatrics. Our commitment to excellence ensures that patients have
                            access to top-tier medical expertise and advanced treatment options.
                        </p>
                        <p>
                            At The Modern Hospital Karachi, we strive to create a comprehensive healthcare
                            experience that prioritizes your well-being at every step of the journey.
                        </p>
                    </div>
                </div>

            </div>
        </div>


      <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\E Drive\Projects\The Modren Hospital\tmh\resources\views/pages/hospitals/karachi.blade.php ENDPATH**/ ?>