<?php $__env->startSection('title', 'The Modern Hospital'); ?>

<?php $__env->startSection('content'); ?>

  
  <div id="smooth-wrapper">
    <div id="smooth-content">

      
      <div id="hero-section-new" class="d-flex align-items-center">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12">
              <div id="hero-slider" style="height: 70vh;">
                <div class="hero-wrapper">
                  <img class="hero-img" src="<?php echo e(asset('assets/images/resource/home/home-banner-with-overlay.png')); ?>" alt="">
                  <img class="banner-text-img" src="<?php echo e(asset('assets/images/resource/home/banner-text-img.png')); ?>" alt="">
                </div>
                <div class="hero-wrapper">
                  <img class="hero-img" src="<?php echo e(asset('assets/images/resource/home/home-banner-with-overlay.png')); ?>" alt="">
                  <img class="banner-text-img" src="<?php echo e(asset('assets/images/resource/home/banner-text-img.png')); ?>" alt="">
                </div>
              </div>

              <div class="hero-stats_wrapper">
                <img class="hero-stats-overlay" src="<?php echo e(asset('assets/images/resource/home/hero-stats.png')); ?>" alt="">
                <div class="hero-stats">
                  <div class="hero-stat_item"><div><h2>7</h2><p>Hospitals</p></div><hr /></div>
                  <div class="hero-stat_item"><div><h2>14+</h2><p>Clinics</p></div><hr /></div>
                  <div class="hero-stat_item"><div><h2>10k</h2><p>Satisfied Patients</p></div><hr /></div>
                  <div class="hero-stat_item"><div><h2>15</h2><p>Ambulances</p></div><hr /></div>
                  <div class="hero-stat_item"><div><h2>100+</h2><p>Medical Staff</p></div><hr /></div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>

      
      <div class="feature-serction">
        <div class="container">
          <div class="row">
            
            <div class="col-lg-3 col-md-6">
            <div class="feature-single-box feature-single-box-1 box-1" data-aos="fade-down">
                <div class="feature-head"><div class="head-title"><h2>Find a <br>Doctor</h2></div></div>
                <div class="feature-content text-center">
                <form>
                    
                    <div class="input-group">
                    <input
                        type="text"
                        id="home-branch"
                        name="branch"
                        list="branchList"
                        placeholder="Choose Location.."
                        autocomplete="off">
                    <img src="<?php echo e(asset('assets/images/resource/home/location-icon.png')); ?>" alt="">
                    </div>
                    <datalist id="branchList">
                    <?php $__currentLoopData = $branches ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($branch); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>

                    
                    <div class="input-group">
                    <input
                        type="text"
                        id="home-dept"
                        name="specialty"
                        list="deptList"
                        placeholder="Search Here.."
                        autocomplete="off">
                    <img src="<?php echo e(asset('assets/images/resource/home/magnifier-icon.png')); ?>" alt="">
                    </div>
                    <datalist id="deptList">
                    <?php $__currentLoopData = $departments ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dept); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>

                    <div class="feature-btn cursor-scale small">
                    
                    <a href="<?php echo e(url('/find-a-doctor')); ?>" id="home-find-btn">Search</a>
                    </div>
                </form>
                </div>
                <div class="mediic-hover-box hover-bx"></div>
                <div class="mediic-hover-box hover-bx2"></div>
                <div class="mediic-hover-box hover-bx3"></div>
                <div class="mediic-hover-box hover-bx4"></div>
            </div>
            </div>

            
            <script>
            document.addEventListener('DOMContentLoaded', function () {
                var btn    = document.getElementById('home-find-btn');
                var branch = document.getElementById('home-branch');
                var dept   = document.getElementById('home-dept');

                if (btn && branch && dept) {
                btn.addEventListener('click', function (e) {
                    e.preventDefault();
                    var base = this.getAttribute('href') || '<?php echo e(url('/find-a-doctor')); ?>';
                    var params = new URLSearchParams();

                    // branch from first input
                    if (branch.value && branch.value.trim() !== '') {
                    params.set('branch', branch.value.trim());
                    }

                    // department from second input (controller expects "specialty" as department)
                    if (dept.value && dept.value.trim() !== '') {
                    params.set('specialty', dept.value.trim().toUpperCase());
                    }

                    // keep defaults if user left empty (optional)
                    if (!params.has('branch'))    params.set('branch', 'KARACHI');
                    // if user leaves department empty, you can omit or set ALL
                    if (!params.has('specialty')) params.set('specialty', 'ALL');

                    window.location.href = base + '?' + params.toString();
                });
                }
            });
            </script>


            
            <div class="col-lg-3 col-md-6">
              <div class="feature-single-box feature-single-box-1 box-2" data-aos="fade-down">
                <div class="feature-head"><div class="head-title"><h2>Book an <br>Appointment</h2></div></div>
                <div class="feature-content text-center">
                  <form>
                    <div class="input-group"><input type="text" placeholder="First Name.."></div>
                    <div class="input-spacer"></div>
                    <div class="feature-btn cursor-scale small">
                      <a href="<?php echo e(url('/book-appointment')); ?>">Search</a>
                    </div>
                  </form>
                </div>
                <div class="mediic-hover-box hover-bx"></div>
                <div class="mediic-hover-box hover-bx2"></div>
                <div class="mediic-hover-box hover-bx3"></div>
                <div class="mediic-hover-box hover-bx4"></div>
              </div>
            </div>

            
            <div class="col-lg-3 col-md-6">
              <div class="feature-single-box feature-single-box-1 box-3" data-aos="fade-down">
                <div class="feature-head"><div class="head-title"><h2>Request LAB or <br>Diagnostic Reports</h2></div></div>
                <div class="feature-content text-center">
                  <form>
                    <div class="input-group"><input type="text" placeholder="User ID.."></div>
                    <div class="input-group"><input type="text" placeholder="Password.."></div>
                    <div class="feature-btn cursor-scale small"><a href="<?php echo e(url('/appointment')); ?>">Search</a></div>
                  </form>
                </div>
                <div class="mediic-hover-box hover-bx"></div>
                <div class="mediic-hover-box hover-bx2"></div>
                <div class="mediic-hover-box hover-bx3"></div>
                <div class="mediic-hover-box hover-bx4"></div>
              </div>
            </div>

            
            <div class="col-lg-3 col-md-6">
              <div class="feature-single-box feature-single-box-1 box-4" data-aos="fade-down">
                <div class="feature-head"><div class="head-title"><h2>Doorstep Sample <br>Collection</h2></div></div>
                <div class="feature-content text-center">
                  <form>
                    <div class="input-group"><input type="text" placeholder="First Name.."></div>
                    <div class="input-spacer"></div>
                    <div class="feature-btn cursor-scale small"><a href="<?php echo e(url('/appointment')); ?>">Search</a></div>
                  </form>
                </div>
                <div class="mediic-hover-box hover-bx"></div>
                <div class="mediic-hover-box hover-bx2"></div>
                <div class="mediic-hover-box hover-bx3"></div>
                <div class="mediic-hover-box hover-bx4"></div>
              </div>
            </div>
          </div>
        </div>
      </div>

      
      <div class="about-serction">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="top-mediic-section">
                <div class="mediic-section-title cursor-scale" data-aos="flip-right">
                  <h1>About Us</h1>
                </div>
                <div class="counter-single-box bx-2 cursor-scale" data-aos="fade-down">
                  <div class="odometer-wrapper counter-box-title" data-count="15">
                    <h1 class="odometer"></h1><h1>+</h1>
                    <p class="counter-desc">YEARS OF EXPERIENCE</p>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="row about-bg align-items-center">
            <div class="col-lg-7">
              <div class="about-thumb" data-aos="fade-up-right">
                <img src="<?php echo e(asset('assets/images/resource/home/about-img.png')); ?>" alt="" />
                <div class="thumbs-bxs">
                  <div class="icon">
                    <img class="logo-small" src="<?php echo e(asset('assets/images/resource/logo-small-1.png')); ?>" alt="" />
                  </div>
                  <div class="text-circle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="250.5" height="250.5" viewBox="0 0 250.5 250.5">
                      <path d="M.25,125.25a125,125,0,1,1,125,125,125,125,0,0,1-125-125" id="e-path"></path>
                      <text><textPath href="#e-path" startOffset="0%">DELIVERING CARE  *  BEYOND COMPARE  *  </textPath></text>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-5" data-aos="fade-up-left">
              <div class="mediic-section-title2">
                <p>The Modern Hospital is a <span class="color-danger">not-for-profit</span> hospital, founded in XXXX on the belief that healthcare is a sacred trust.</p>
                <p>Guided by our slogan, <span class="color-primary">“Taluq Eman Ka”—The Relation of Faith</span>—we place humanity at the forefront of everything we do…</p>
                <p>Located in the heart of Karachi, our 100-bed facility…</p>
              </div>
              <div class="mediic-btn cursor-scale small">
                <a href="<?php echo e(url('/about-us')); ?>">Read More <i class="bi bi-arrow-return-right"></i></a>
              </div>
            </div>

            <div class="mediic-shape" data-aos="fade-up-left">
              <img src="<?php echo e(asset('assets/images/resource/home/stethoscope.png')); ?>" alt="" />
            </div>
          </div>
        </div>
      </div>

      
      <div class="video-section" data-aos="flip-right">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="video-container">
                <!-- Video Element -->
                <video id="customVideo" width="100%" height="auto"
                  poster="<?php echo e(asset('assets/images/resource/home/video-fallback.png')); ?>">
                  <source src="<?php echo e(asset('assets/images/resource/home/videoplayback.mp4')); ?>" type="video/mp4" />
                  Your browser does not support the video tag.
                </video>

                <!-- Custom Play Button -->
                <div class="custom-play-button" id="customPlayButton"></div>
              </div>
            </div>
          </div>
        </div>
      </div>

      
      <div class="carousal-section">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12 p-0">
              <h2>Virtual Tour<br /> The Modern Hospital</h2>
              <div class="carousel-container">
                <img class="carousel" src="<?php echo e(asset('assets/images/resource/home/360-carousal.png')); ?>" alt="">
                <img class="carousel-text" src="<?php echo e(asset('assets/images/resource/home/360-text.png')); ?>" alt="">
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-12">
              <div class="mediic-btn cursor-scale small text-center">
                <a href="about.html">Visit Hospital Virtually <i class="bi bi-arrow-return-right"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>

      
      <div class="marquee-section">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12">
              <div class="marquee cursor-scale" data-aos="zoom-out-left">
                <div class="marquee-single-box">
                  <div class="marquee-content">
                    <h2>
                      GYNOCLOGIST
                      <span><img src="<?php echo e(asset('assets/images/resource/logo-small-1.png')); ?>" alt="" /></span>
                    </h2>
                    <h2>
                      CARDIOLOGIST
                      <span><img src="<?php echo e(asset('assets/images/resource/logo-small-1.png')); ?>" alt="" /></span>
                    </h2>
                    <h2>
                      NUEROLOGIST
                      <span><img src="<?php echo e(asset('assets/images/resource/logo-small-1.png')); ?>" alt="" /></span>
                    </h2>
                  </div>
                </div>
                <div class="marquee-single-box">
                  <div class="marquee-content">
                    <h2>
                      GYNOCLOGIST
                      <span><img src="<?php echo e(asset('assets/images/resource/logo-small-1.png')); ?>" alt="" /></span>
                    </h2>
                    <h2>
                      CARDIOLOGIST
                      <span><img src="<?php echo e(asset('assets/images/resource/logo-small-1.png')); ?>" alt="" /></span>
                    </h2>
                    <h2>
                      NUEROLOGIST
                      <span><img src="<?php echo e(asset('assets/images/resource/logo-small-1.png')); ?>" alt="" /></span>
                    </h2>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      
      <div class="mediic-top-section bg-dark">
        <div class="container-fluid">
          <div class="row align-items-center">
            <div class="col-lg-12">
              <div class="top-mediic-section bg-dark">
                <div class="mediic-section-title cursor-scale white" data-aos="flip-left">
                  <h1>Provides Best</h1>
                  <h1>Health Services</h1>
                </div>
                <div class="mediic-desc" data-aos="fade-up">

                </div>
                <div class="mediic-btn cursor-scale small" data-aos="fade-down">
                  <a href="#">View All Services <i class="bi bi-arrow-return-right"></i></a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="service-section">
        <div class="container-fluid">
          <div class="row">
            <!-- Swiper -->
            <div class="swiper mySwiper">
              <div class="swiper-wrapper">
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-out">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/child-specialist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Child Specialist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-in">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/physiotherapist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Physiotherapist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-out">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/cardiologist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Cardiologist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-in">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/ophthalmologists.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Ophthalmologists</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-out">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/child-specialist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Child Specialist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-in">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/physiotherapist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Physiotherapist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-out">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/cardiologist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Cardiologist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-in">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/ophthalmologists.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Ophthalmologists</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-out">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/child-specialist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Child Specialist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-in">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/physiotherapist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Physiotherapist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-out">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/cardiologist.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Cardiologist</h6>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="single-service-box" data-aos="zoom-in">
                    <div class="service-thumb">
                      <img src="<?php echo e(asset('assets/images/resource/home/ophthalmologists.png')); ?>" alt="" />
                      <div class="service-icon cursor-scale small">
                        <a href="project.html"><i class="bi bi-arrow-return-right"></i></a>
                      </div>
                    </div>
                    <div class="service-content">
                      <h6>Ophthalmologists</h6>
                    </div>
                  </div>
                </div>


              </div>
              <!-- <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div> -->
              <div class="swiper-scrollbar"></div>
            </div>
          </div>
        </div>
      </div>

      
      <div class="our-services-section">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="top-mediic-section">
                <div class="mediic-section-title" data-aos="flip-right">
                  <h1 class="cursor-scale">
                    What's New
                  </h1>
                </div>
              </div>
            </div>

            <!-- <div class="row">
            <div class="top-mediic-section">
              <div class="mediic-section-title text-center">
                <h1>What's New</h1>
              </div>
            </div>
          </div> -->
            <div class="mediic-shape">
              <img src="<?php echo e(asset('assets/images/resource/shape1.png')); ?>" alt="shape" />
            </div>
            <div class="row whats-new">
              <div class="">
                <div class="whats-new-item"
                  style="background-image: url(/assets/images/resource/home/whats-new/ent-img.png);">
                  <div class="overlay"></div>
                  <img src="<?php echo e(asset('assets/images/resource/home/whats-new/ent-icon.png')); ?>" alt="">
                  <a href="#!">
                    <h3>ENT<br />Treatment Services</h3>
                  </a>
                  <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Fugit, sint? Perferendis, enim eius
                    laborum dicta, sequi at ad velit neque dolorum quia ea ratione harum similique nemo sit non libero!
                  </p>

                </div>
              </div>
              <div class="">
                <div class="whats-new-item"
                  style="background-image: url(/assets/images/resource/home/whats-new/hair-care-img.png);">
                  <div class="overlay"></div>
                  <img src="<?php echo e(asset('assets/images/resource/home/whats-new/hair-care-icon.png')); ?>" alt="">
                  <a href="#!">
                    <h3>EXCLUSIVE<br />HAIR CARE CLINIC</h3>
                  </a>
                  <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Fugit, sint? Perferendis, enim eius
                    laborum dicta, sequi at ad velit neque dolorum quia ea ratione harum similique nemo sit non libero!
                  </p>
                </div>
              </div>
              <div class="">
                <div class="whats-new-item"
                  style="background-image: url(/assets/images/resource/home/whats-new/expect-img.png);">
                  <div class="overlay"></div>
                  <img src="<?php echo e(asset('assets/images/resource/home/whats-new/expect-icon.png')); ?>" alt="">
                  <a href="#!">
                    <h3>SPECIAL OFFER FOR EXPECTANT MOTHERS</h3>
                  </a>
                  <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Fugit, sint? Perferendis, enim eius
                    on libero!
                  </p>
                </div>
              </div>
              <div class="">
                <div class="whats-new-item"
                  style="background-image: url(/assets/images/resource/home/whats-new/degenerate-img.png);">
                  <div class="overlay"></div>
                  <img src="<?php echo e(asset('assets/images/resource/home/whats-new/degenerate-icon.png')); ?>" alt="">
                  <a href="#!">
                    <h3>Catch Age-Related <br>Mascular <br>Degeneration Early</h3>
                  </a>
                  <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Fugit, sint? Perferendis, enim eius
                    laborum dicta, sequi at ad velit neque dolorum quia ea ratione harum similique nemo sit non libero!
                  </p>
                </div>
              </div>
              <div class="col-lg-3 ">
                <div class="whats-new-item"
                  style="background-image: url(/assets/images/resource/home/whats-new/degenerate-img.png);">
                  <div class="overlay"></div>
                  <img src="<?php echo e(asset('assets/images/resource/home/whats-new/degenerate-icon.png')); ?>" alt="">
                  <a href="#!">
                    <h3>Dummy</h3>
                  </a>
                  <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Fugit, sint? Perferendis, enim eius
                    laborum dicta, sequi at ad velit neque dolorum quia ea ratione harum similique nemo sit non libero!
                  </p>
                </div>
              </div>
              <div class="col-lg-3 ">
                <div class="whats-new-item"
                  style="background-image: url(/assets/images/resource/home/whats-new/degenerate-img.png);">
                  <div class="overlay"></div>
                  <img src="<?php echo e(asset('assets/images/resource/home/whats-new/degenerate-icon.png')); ?>" alt="">
                  <a href="#!">
                    <h3>Dummy</h3>
                  </a>
                </div>
              </div>

            </div>

          </div>
        </div>
        
        <div class="mobile-app-section">
          <div class="container-fluid p-0">
            <div class="row">
              <div class="col-lg-3 col-md-3 d-flex align-items-center justify-content-center">
                <img src="<?php echo e(asset('assets/images/resource/home/app-logo.png')); ?>" alt="" class="app-logo">
              </div>
              <div class="col-lg-5 col-md-5 py-5" style="z-index: 1;">
                <div class="app-content">
                  <h2>TMH Sehat Mobile App​​</h2>
                  <p>TMH Sehat App provides patients' access to their personal health records through a web portal and
                    mobile applications.</p>
                  <img src="<?php echo e(asset('assets/images/resource/home/app-links.png')); ?>" alt="">
                </div>


              </div>
              <div class="col-lg-4 col-md-4 app-screen-wrapper">
                <img src="<?php echo e(asset('assets/images/resource/home/app-screen.png')); ?>" alt="" class="app-screen">
              </div>
            </div>
          </div>
        </div>

        
        <div class="blog-section">
          <div class="container">
            <div class="row">
              <div class="col-lg-12">
                <div class="top-mediic-section">
                  <div class="mediic-section-title" data-aos="flip-right">
                    <h1 class="cursor-scale">
                      Read
                      <br />
                      News And Blogs
                    </h1>
                  </div>
                  <div class="mediic-btn cursor-scale small" data-aos="fade-down">
                    <a href="#">View All <i class="bi bi-arrow-return-right"></i></a>
                  </div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-4 col-md-6">
                <div class="blog-single-box" data-aos="fade-up">
                  <div class="blog-thumb">
                    <img src="<?php echo e(asset('assets/images/resource/blog/blog-monkeypox.png')); ?>" alt="" />
                    <div class="mediic-hover-box hover-bx"></div>
                    <div class="mediic-hover-box hover-bx2"></div>
                    <div class="mediic-hover-box hover-bx3"></div>
                    <div class="mediic-hover-box hover-bx4"></div>
                  </div>
                  <div class="blog-content">
                    <div class="blogs-category">
                      <ul>
                        <li class="blg-date">SEPTEMBER 6, 2024</li>
                        <li class="blg-admin">ADMIN</li>
                      </ul>
                    </div>
                    <div class="blog-title">
                      <h2 class="cursor-scale small">
                        <a href="blog-details.html">Understanding Monkeypox: Symptoms, Transmission, and Care</a>
                      </h2>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-6">
                <div class="blog-single-box" data-aos="fade-down">
                  <div class="blog-thumb">
                    <img src="<?php echo e(asset('assets/images/resource/blog/blog-conguctivitus.png')); ?>" alt="" />
                    <div class="mediic-hover-box hover-bx"></div>
                    <div class="mediic-hover-box hover-bx2"></div>
                    <div class="mediic-hover-box hover-bx3"></div>
                    <div class="mediic-hover-box hover-bx4"></div>
                  </div>
                  <div class="blog-content">
                    <div class="blogs-category">
                      <ul>
                        <li class="blg-date">SEPTEMBER 10, 2024</li>
                        <li class="blg-admin">AUTHOR</li>
                      </ul>
                    </div>
                    <div class="blog-title">
                      <h2 class="cursor-scale small">
                        <a href="blog-details.html">Understanding Conjunctivitis: Causes, Symptoms, and Treatment
                          Options
                          at Modern Hospital</a>
                      </h2>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-6">
                <div class="blog-single-box" data-aos="fade-up">
                  <div class="blog-thumb">
                    <img src="<?php echo e(asset('assets/images/resource/blog/blog-breast_cancer.png')); ?>" alt="" />
                    <div class="mediic-hover-box hover-bx"></div>
                    <div class="mediic-hover-box hover-bx2"></div>
                    <div class="mediic-hover-box hover-bx3"></div>
                    <div class="mediic-hover-box hover-bx4"></div>
                  </div>
                  <div class="blog-content">
                    <div class="blogs-category">
                      <ul>
                        <li class="blg-date">MARCH 16, 2024</li>
                        <li class="blg-admin">ADMIN</li>
                      </ul>
                    </div>
                    <div class="blog-title">
                      <h2 class="cursor-scale small">
                        <a href="blog-details.html">Breast Cancer Awareness: Key to Early Diagnosis and Effective
                          Treatment</a>
                      </h2>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <div class="mediic-top-section style-2">
          <div class="container">
            <div class="row">
              <div class="col-lg-12">
                <div class="top-mediic-section">
                  <div class="mediic-section-title" data-aos="flip-right">
                    <h1 class="cursor-scale">
                      Patient
                      <br />
                      Success Stories
                    </h1>
                  </div>
                  <div class="mediic-btn cursor-scale small" data-aos="fade-down">
                    <a href="#">View All <i class="bi bi-arrow-return-right"></i></a>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
        <div class="testimonial-section">
          <div class="container">
            <div class="row">
              <div class="col-lg-8">
                <div class="testi-thumb" data-aos="zoom-in-right">
                  <img src="<?php echo e(asset('assets/images/resource/home/testimonial-bg.png')); ?>" alt="" />
                </div>
              </div>
              <div class="col-lg-4">
                <div class="swiper mySwiper6" data-aos="zoom-in-left">
                  <div class="swiper-wrapper">
                    <div class="swiper-slide">
                      <div class="testi-single-box">
                        <div class="testi-content-2">
                          <div class="testi-quote">
                            <img src="<?php echo e(asset('assets/images/resource/quote.png')); ?>" alt="" />
                          </div>
                          <ul class="testi-rating">
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                          </ul>
                          <div class="testi-desc">
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer
                              adipiscing elit, sed diam nonummy nibh euis-
                              mod tincidunt ut laoreet dolore magna
                              aliquam erat volutpat. Ut wisi enim ad minim
                              veniam, quis nostrud exerci tation ullamcorp-
                              er suscipit lobortis nisl ut aliquip ex ea com-
                            </p>
                          </div>
                          <div class="user-info">
                            <div class="people-pic">
                              <img src="<?php echo e(asset('assets/images/resource/people.png')); ?>" alt="" />
                            </div>
                            <div class="user-name">
                              <h4>Anza Memon</h4>
                              <h6>Heart Patient</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="swiper-slide">
                      <div class="testi-single-box">
                        <div class="testi-content-2">
                          <div class="testi-quote">
                            <img src="<?php echo e(asset('assets/images/resource/quote.png')); ?>" alt="" />
                          </div>
                          <ul class="testi-rating">
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                          </ul>
                          <div class="testi-desc">
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer
                              adipiscing elit, sed diam nonummy nibh euis-
                              mod tincidunt ut laoreet dolore magna
                              aliquam erat volutpat. Ut wisi enim ad minim
                              veniam, quis nostrud exerci tation ullamcorp-
                              er suscipit lobortis nisl ut aliquip ex ea com-
                            </p>
                          </div>
                          <div class="user-info">
                            <div class="people-pic">
                              <img src="<?php echo e(asset('assets/images/resource/people.png')); ?>" alt="" />
                            </div>
                            <div class="user-name">
                              <h4>Anza Memon</h4>
                              <h6>Heart Patient</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="swiper-slide">
                      <div class="testi-single-box">
                        <div class="testi-content-2">
                          <div class="testi-quote">
                            <img src="<?php echo e(asset('assets/images/resource/quote.png')); ?>" alt="" />
                          </div>
                          <ul class="testi-rating">
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                          </ul>
                          <div class="testi-desc">
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer
                              adipiscing elit, sed diam nonummy nibh euis-
                              mod tincidunt ut laoreet dolore magna
                              aliquam erat volutpat. Ut wisi enim ad minim
                              veniam, quis nostrud exerci tation ullamcorp-
                              er suscipit lobortis nisl ut aliquip ex ea com-
                            </p>
                          </div>
                          <div class="user-info">
                            <div class="people-pic">
                              <img src="<?php echo e(asset('assets/images/resource/people.png')); ?>" alt="" />
                            </div>
                            <div class="user-name">
                              <h4>Anza Memon</h4>
                              <h6>Heart Patient</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="swiper-slide">
                      <div class="testi-single-box">
                        <div class="testi-content-2">
                          <div class="testi-quote">
                            <img src="<?php echo e(asset('assets/images/resource/quote.png')); ?>" alt="" />
                          </div>
                          <ul class="testi-rating">
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                          </ul>
                          <div class="testi-desc">
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer
                              adipiscing elit, sed diam nonummy nibh euis-
                              mod tincidunt ut laoreet dolore magna
                              aliquam erat volutpat. Ut wisi enim ad minim
                              veniam, quis nostrud exerci tation ullamcorp-
                              er suscipit lobortis nisl ut aliquip ex ea com-
                            </p>
                          </div>
                          <div class="user-info">
                            <div class="people-pic">
                              <img src="<?php echo e(asset('assets/images/resource/people.png')); ?>" alt="" />
                            </div>
                            <div class="user-name">
                              <h4>Anza Memon</h4>
                              <h6>Heart Patient</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="swiper-slide">
                      <div class="testi-single-box">
                        <div class="testi-content-2">
                          <div class="testi-quote">
                            <img src="<?php echo e(asset('assets/images/resource/quote.png')); ?>" alt="" />
                          </div>
                          <ul class="testi-rating">
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                          </ul>
                          <div class="testi-desc">
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer
                              adipiscing elit, sed diam nonummy nibh euis-
                              mod tincidunt ut laoreet dolore magna
                              aliquam erat volutpat. Ut wisi enim ad minim
                              veniam, quis nostrud exerci tation ullamcorp-
                              er suscipit lobortis nisl ut aliquip ex ea com-
                            </p>
                          </div>
                          <div class="user-info">
                            <div class="people-pic">
                              <img src="<?php echo e(asset('assets/images/resource/people.png')); ?>" alt="" />
                            </div>
                            <div class="user-name">
                              <h4>Anza Memon</h4>
                              <h6>Heart Patient</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="swiper-slide">
                      <div class="testi-single-box">
                        <div class="testi-content-2">
                          <div class="testi-quote">
                            <img src="<?php echo e(asset('assets/images/resource/quote.png')); ?>" alt="" />
                          </div>
                          <ul class="testi-rating">
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                          </ul>
                          <div class="testi-desc">
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer
                              adipiscing elit, sed diam nonummy nibh euis-
                              mod tincidunt ut laoreet dolore magna
                              aliquam erat volutpat. Ut wisi enim ad minim
                              veniam, quis nostrud exerci tation ullamcorp-
                              er suscipit lobortis nisl ut aliquip ex ea com-
                            </p>
                          </div>
                          <div class="user-info">
                            <div class="people-pic">
                              <img src="<?php echo e(asset('ssets/images/resource/people.png')); ?>a" alt="" />
                            </div>
                            <div class="user-name">
                              <h4>Anza Memon</h4>
                              <h6>Heart Patient</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="swiper-slide">
                      <div class="testi-single-box">
                        <div class="testi-content-2">
                          <div class="testi-quote">
                            <img src="<?php echo e(asset('assets/images/resource/quote.png')); ?>" alt="" />
                          </div>
                          <ul class="testi-rating">
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                            <li><i class="bi bi-star-fill"></i></li>
                          </ul>
                          <div class="testi-desc">
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer
                              adipiscing elit, sed diam nonummy nibh euis-
                              mod tincidunt ut laoreet dolore magna
                              aliquam erat volutpat. Ut wisi enim ad minim
                              veniam, quis nostrud exerci tation ullamcorp-
                              er suscipit lobortis nisl ut aliquip ex ea com-
                            </p>
                          </div>
                          <div class="user-info">
                            <div class="people-pic">
                              <img src="<?php echo e(asset('assets/images/resource/people.png')); ?>" alt="" />
                            </div>
                            <div class="user-name">
                              <h4>Anza Memon</h4>
                              <h6>Heart Patient</h6>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\E Drive\Projects\The Modren Hospital\tmh\resources\views/pages/home.blade.php ENDPATH**/ ?>